require( "scripts/style.lua" );


kMainMenuButtonSound="audio/sfx/menu_click.ogg";
kMainMenuRolloverButtonSound="audio/sfx/menu_rollover.ogg";
MainMenuStyle = {
	parent = DefaultStyle,
	sound = kMainMenuButtonSound,
	rolloversound = kMainMenuRolloverButtonSound
};

GameModeFont = {
	standardFont,
	24,
	BorderColor
};

WelcomeFont = {
	standardFont,
	14,
	BorderColor
};

MenuFont = {
	standardFont,
	40,
	BorderColor
};

TipFont = {
	standardFont,
	24,
	BorderColor
};

CopyrightFont = {
  "fonts/default.mvec",
  12,
  Color(0,0,0,255);
};

TrademarkFont = {
  "fonts/default.mvec",
  8,
  Color(0,0,0,255);
};

RegisteredFont = {
  "fonts/default.mvec",
  12,
  Color(0,0,0,255);
};



kRotationAmount = 3.0;

MenuButtonRotateStyle = {
	parent = DefaultStyle,
	x = 0, y = 0, 
	flags = kHAlignCenter + kVAlignCenter,
	rotation = kRotationAmount,
	rotationOriginX = kCenter,
	rotationOriginY = kCenter
};


kButtonTextShift = 4;




function SlideWindows()
	SlideMovingWindow('movinglogo', true);
	SlideMovingWindow('movingtitle', true);
	SlideMovingWindow('storetray', true);
	SlideMovingWindow('movingtray', true);
	SlideMovingWindow('movingbottom', true);
end

					
					
					

function MakeCustomizeButton()
	return Group {
		SetStyle(MainMenuButtonStyle4);
		Button
		{
			x=0,
			y=180,
			name="floscloset",
			label="floscloset",
			--rolloverwindow="mainmenupopup",
			--rollovertext="mm_flosclosettip",
			command=
				function()
					SetDefaultGameSettings();
					if (CheckName()) then
						ResetWindows();
						DoModal('scripts/floscloset.lua');
					end	
				end
		},
	}
end



MakeDialog
{
	x = 0,
	y = 0,
	w = 800,
	h = 600,
	name = "mainmenumodal",
	

	
	Bitmap
	{ 
		name="backgroundimage",
		image="menu/mainmenu",	
			
		MainMenu
		{
			name="mainmenuwindow",
			SetStyle(MainMenuStyle);
			x = 0,
			y = 0,
			w = 800,
			h = 600,
			fit = false,
		
			
				
			Text
			{
				font = CopyrightFont,
				name="copyright",
				label="copyright",
				x=5,
				y=500,
				w=170,
				h=36,
				flags = kHAlignLeft + kVAlignCenter,
				padding = 0
			},
			
			

				
			Window
			{
				x=640,
				y=245,
				image = "menu/tray_sp",
				
				SetStyle(MainMenuButtonStyle4);
				Button
				{
					x=0,
					y=90,
					name="gamemode1",
					label="gamemode1",
					--rolloverwindow="mainmenupopup",
					--rollovertext="mm_storymodetip",
					command=
						function()
							if (LimitedTrialExpired(true)) then
								DisplayDialog { 
									"scripts/ok.lua", 
									body ="timetrialexpired",
									title = ""
								};
							else
								SetDefaultGameSettings();
								if (CheckName()) then
									PopModal("mainmenumodal");
									LaunchMapScreen(false);
								end
							end
						end
				},
				
				Button
				{
					x=0,
					y=135,
					name="gamemode2",
					label="gamemode2",
					--rolloverwindow="mainmenupopup",
					--rollovertext="mm_endlessmodetip",
					command=
						function()
							if (IsFirstPeek()) then
								DisplayDialog{
									'scripts/ok.lua', 
									body ='notinfirstpeek',
									title = ''
								};
							else
								SetDefaultGameSettings();
								SetCurrentGameMode(1);
								if (CheckName()) then
									PopModal("mainmenumodal");
									ForceMyWaiterCreation(true);
									LaunchMapScreen(false);
								end
							end
						end
				},
				
				MakeCustomizeButton();
				
				SetStyle(DefaultStyle);
				
				
				
			};
			
			Bitmap
			{
				x = 11,
				y = 3,
				image = "menu/mpmenu/dinerdash_logo"
			};
			
			MovingWindow
			{
				name="movingbottom",
				x=kCenter,y=-70,
				dirX = 0,
				dirY = 1,
				startoff = 1,
				onDelay = 0,
				Bitmap
				{
					x = 0,
					y = 0,
					image = "menu/bezel_sp",
					
					AutoFitText
					{
						font = WelcomeFont,
						name = "playername",
						x=44,y=35,w=269,h=22,
						flags = kHAlignCenter + kVAlignCenter,
						label = ""
					};
					
					SetStyle(ChangePlayerButtonStyle);
					Button
					{
						x=350,
						y=42,
						name="changeplayer",
						label="changeplayer",
						command=
							function()
								DoModal("scripts/chooseplayer.lua");
							end
					},
					
					
					SetStyle(MainMenuButtonStyle1);
					
					Button
					{
						x=520,
						y=38,
						name="options",
						label="options",
						command=
							function()
								if (CheckName()) then
									DoModal("scripts/options.lua");
								end
							end
					},
					
					SetStyle(MainMenuQuitStyle);
					Button
					{
						x=686,
						y=38,
						name="quit",
						label="quit",
						command=
							function()
								result = DisplayDialog { 
									"scripts/yesno.lua", 
									body ="quitconfirm",
									title = "" 
								};
								if (result=='yes') then
									PostMessage( CreateNamedMessage( kQuitNow, "Quit" ) );
								end
							end
					},
					SetStyle(DefaultStyle);
				};
			};
			

			FadingWindow
			{
				x = 38,
				y = 150,
				name = "mainmenupopup",
				lengthon = 500,
				lengthoff = 500,
				startoff = 1,
				
				Bitmap
				{
					x = 0,
					y = 0,
					image = "menu/text_bubble",
					
					
					Text
					{
						x=36,y=24,
						w=247,h=77,
						flags = kHAlignCenter + kVAlignCenter,
						font=TipFont,
						name="mainmenupopup_text",
						label=''
					};
				};
			};
			
			SetStyle(MainMenuButtonStyle1);
			Button
			{
				x=680,
				y=500,
				name="moregames",
				label="moregames",
				type = kPush,
				xoffset = 1,
				yoffset = 1,
				command=
					function()
						DoModal("xsell/xsell.lua");
					end
			},
			
			
			
			SetStyle(DefaultStyle);

			
			Button
			{
				x=670,
				y=530,
				font = WelcomeFont,
				graphics = SolidButtonGraphics,
				name="editors",
				label="le_editors",
				type = kPush,
				xoffset = 1,
				yoffset = 1,
				command=
					function()
						if (CheckName()) then
							SetDefaultGameSettings();
							DoModal("scripts/leveleditor/editors.lua");
						end
						
					end
			},
		}
	}
}


PlayMainMenuMusic();
if (GetGlobalBoolSetting("new_multiplayer", true) == false) then
	EnableWindow("new_multiplayer", false);
end
if (GetGlobalBoolSetting("new_customize", true) == false) then
	EnableWindow("new_customize", false);
end
SetRestartScreen(GetMainMenuScript());